package org.msh.tb.bd.tbforms.dhis2.tb10.blockbuilders;

import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block6CQuery;
import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.entities.enums.TbFormField;

/**
 * Created by Mauricio on 08/03/2017.
 * Query database and mount TB Form 10 Block 6C Payload to be sent to DHIS2 APIs
 */
public class TBForm10Block6CBuilder extends TBFormBlockBuilder {

    private TBForm10Block6CQuery formQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (TbFormField field : getBlockQuery().fields) {
            payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(0));
        }
    }

    @Override
    protected TBForm10Block6CQuery getBlockQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block6CQuery();
        }

        return formQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        TbFormField field = (TbFormField) result[0];
        Integer count = (Integer) result[1];

        // merge payload result
        payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(count));
    }
}
